"Dance to the Beat of the Earth" by "Victor Gijsbers"

Include Inform ATTACK by Victor Gijsbers.
[Include Unicode Character Names by Graham Nelson.]
Include Basic Screen Effects by Emily Short.

Understand "zenith" as up. Understand "azimuth" as down.
Understand "observe [something]" as examining.

Section - Regions and Backdrops

Outside Area is a region.

Grace is a backdrop. Grace is everywhere. Understand "radiance" and "light" as grace. Instead of examining Grace: say "Wherever the Gods have power, their light can be seen. And wherever their light can be seen, you will be safe.". Instead of touching Grace: say "The feeling of safety.".

The Gods are a backdrop. The Gods are in Outside Area. Instead of examining the Gods: say "They are looking down, judging our actions: cold, rational Mercury; loving, harmonious Venus; powerful Jupiter; violent Mars; and that most enigmatic of deities, the mysterious Luna.".

Mercury is a backdrop. Mercury is in Outside Area. Instead of examining Mercury: say "You reverently stare up at the [one of]Maker of Plans[or]Lord of Logic[or]Master of Thought[at random].".

Venus is a backdrop. Venus is in Outside Area. Instead of examining Venus: say "You send up a short prayer to the [one of]Lady of Unity[or]Mirror of Nature[or]Queen of Love[at random].".

Jupiter is a backdrop. Jupiter is in Outside Area. Instead of examining Jupiter: say "For a moment you contemplate the majesty of the [one of]Great King[or]Transcendent One[or]All-Destroyer[at random].".

Mars is a backdrop. Mars is in Outside Area. Instead of examining Mars: say "You welcome the red light of the [one of]Lord of War[or]Master at Arms[or]Great General[at random].".

Luna is a backdrop. Understand "moon" as Luna. Luna is in Outside Area. Instead of examining Luna: say "You bask in the radiance of the [one of]Mysterious One[or]Lady[or]Queen of the Night[at random].".

Instead of attacking The Gods: say "That would be blasphemous."
Instead of attacking Mercury: say "That would be blasphemous."
Instead of attacking Venus: say "That would be blasphemous."
Instead of attacking Jupiter: say "That would be blasphemous."
Instead of attacking Mars: say "That would be blasphemous."
Instead of attacking Luna: say "That would be blasphemous."

The Eternal Laws of Heaven are a backdrop. The Eternal Laws of Heaven are in Outside Area. Instead of examining the Eternal Laws of Heaven: say "Gravitational constant times mass of the attracting body equals acceleration of the attracted body times the square of their distance--you know the Laws and have observed their intricate effects for millennia. But contemplating their changelessness never fails to enrapture.".

The snow is a backdrop. The snow is in Outside Area. Instead of examining the snow: say "As white as flesh, as cold as thought. And partaking of the same beauty.". Instead of taking the snow: say "It would only melt.".

Basking in is an action applying to one thing. Understand "bask in [something]" as basking in.

Carry out basking in: say "You attempt to share in its glory.".
Instead of basking in Grace: say "Its light streams into your soul.".



Section - Hall of Knights

Hall of Knights is a room. "A circular hall carved in red granite, softly illuminated by the cold radiance of Grace. In the middle of the hall a chess board rests on a column of glass.[paragraph break][italic type]Exits: Hall of Flowers (north), Pax Poetica (south)[roman type]."

The player is in Hall of Knights.

Red granite is scenery in Hall of Knights. Instead of examining the red granite: say "The otherwise monotonous red surface is spangled with dark stars of quartz and biotite.". Understand "surface" and "dark" and "stars" and "quartz" and "biotite" and "constellations" and "constellation" as the red granite. Instead of touching the red granite: say "You trace constellations formed by the pieces of quartz.".

A chess board is scenery in the Hall of Knights. Understand "game" and "position" as the chess board. Instead of examining the chess board: say "Many are the days whiled away by meditating on this position. Should you defend, or should you fling your black pieces at your enemy's position in even wilder abandon? A difficult question, but it is Ion's turn this month. You still have time.". Instead of taking the chess board: say "That would disturb the game.".

The pieces are part of the chess board. The pieces are plural-named. Understand "piece" and "knight" and "knights" and "pawn" and "queen" and "king" and "rook" and "bishop" and "white" and "black" as the pieces. Instead of examining the pieces: say "The white pieces are made of platinum, the black pieces of lead. Once they were exquisitely detailed, but much use has eroded their features.". Instead of taking the pieces: say "It is not your turn.". Instead of touching the pieces: say "Cold and smooth. Heavy.".

The column of glass is scenery in the Hall of Knights. Instead of examining the column of glass: say "Shaped like a prism, this seemingly humble object has the power to break the plenum apart--a theme you explored in one of your better-known sonnet cycles.".




Section - Hall of Flowers

Hall of Flowers is north of Hall of Knights. "White marble pillars rise towards the zenith, the central one accompanied by circling stairs made of a delicate gold. It glows with Grace. Along the north wall, niches hold your three flowers.[paragraph break][italic type]Exits: Hall of Knights (south), Observatorium (up)[roman type]."

Before going up in Hall of Flowers: say "You climb the three thousand steps and emerge in the cold winter air.".

White marble pillars are scenery in Hall of Flowers. Understand "central" and "pillar" and "column" and "columns" as the white marble pillars. Instead of examining the white marble pillars: say "In accordance with the First Rule of Good Architecture, these pillars honour the Gods by striving towards them. They decrease the vast distance that separates us from our benefactors by a humble five hundred meters.". Instead of climbing the white marble pillars: say "One must not tempt the Gods.". Instead of touching the white marble pillars: say "Cool and hard.".


Instead of examining up in the Hall of Flowers: say "The ceiling is very high above you.".

The circling stairs are scenery in Hall of Flowers. Understand "stairway" and "staircase" and "gold" and "golden" and "glow" as the circling stairs. Instead of examining the circling stairs: say "Ever-repeating patterns of stars and planets have been filed into the sides of the staircase. It ascends, as staircases must.". Instead of climbing the circling stairs: try going up.

The niches are scenery in Hall of Flowers. Understand "niche" as the niches. Instead of examining the niches: say "One niche holds a rose. One niche holds a lily. One niche holds an orchid. They are invaluable.". Instead of entering the niches: say "Impossible.".

The rose is scenery in Hall of Flowers. Instead of examining the rose: say "You kneel down and stare at the full, dark red flower. Encased in ice, it will bloom for eternity. [italic type]Love. Passion. Sexuality. Anxiety. Rage.[roman type] Concepts so abstract are in this rose made concrete.[paragraph break]You avert your eyes and stand up." Instead of taking the rose: say "Impossible: the ice might melt.". Instead of smelling the rose: say "You smell nothing through the ice.". Instead of touching the rose: say "It is encased in a block of ice.".

The block of ice is scenery in Hall of Flowers. Instead of examining the block of ice: say "Perfectly transparent, it is the crystalline phase of a liquid you have forgotten the name of. It offers a slightly enlarged visible image of the flower enclosed within.". Instead of taking the block of ice: say "Impossible: the ice might melt.". Instead of touching the block of ice: try taking the block of ice. Instead of tasting the block of ice: try taking the block of ice.

The lily is scenery in Hall of Flowers. Instead of examining the lily: say "You kneel down and stare at the large, pale flower. Encased in ice, it will bloom for eternity. [italic type]Purity. Virginity. Renunciation.[roman type] The sight of the lily calms the lower urges as well as the higher.[paragraph break]Before you lose yourself in contemplation, you turn away and stand up." Instead of taking the lily: say "Impossible: the ice might melt.". Instead of smelling the lily: say "You smell nothing through the ice.". Instead of touching the lily: say "It is encased in a block of ice.".

The orchid is scenery in Hall of Flowers. Instead of examining the orchid: say "You kneel down and look at the bright pink flower. Encased in ice, it will bloom for eternity. [italic type]Youth. Abundance. Fertility. Decadence.[roman type] Looking at the small orchid is exhilarating and painful at the same time.[paragraph break]You cannot stand the confused tumble of emotions for long and quickly get back on your feet." Instead of taking the orchid: say "Impossible: the ice might melt.". Instead of smelling the orchid: say "You smell nothing through the ice.". Instead of touching the orchid: say "It is encased in a block of ice.".


Section - Observatorium


Observatorium is up from Hall of Flowers. "Here one stands at night to bask in the radiance of the Gods and observe the eternal laws of the Heavens. It has been snowing. All around you the white city leaps up to the stars.[paragraph break][italic type]Exits: Hall of Flowers (down)[roman type]." Observatorium is in Outside Area.

Before going down in Observatorium: say "Three thousand steps towards the azimuth bring you back to your palace below.".

The white city is scenery. The white city is in Observatorium. Understand "topless" and "towers" as the white city. Instead of examining the white city: say "Its topless towers reach always up, the perfect expression of the human spirit. You love the city. Over the years it has become one with the people.". 



Section - Pax Poetica


[What is not worth being learned by heart is not worth being written.]


[Gates of Horn and Ivory]



The bat is a hostile person in Observatorium. 












Book - Combat


Part - Astral influence

Astral influence is a kind of value. The astral influences are Mercurial, Jovian, Lunar, Martial, Venusian and Terrestrial.

Table of influences
Influence
an astral influence
with 20 blank rows

Power of the Earth is a number that varies. The Power of the Earth is usually 60.

Current Influence is an astral influence that varies.

When play begins:
	repeat with n running from 1 to 20:
		choose row n in the Table of influences;
		let m be a random number between 1 and 100;
		if m is greater than Power of the Earth:
			change Influence entry to a random astral influence;
		otherwise:
			change Influence entry to Terrestrial;
	choose row 1 in the Table of influences;		
	now Current Influence is Influence entry.

Player's turn rule (this is the move astral influences rule):
	let p be Mercurial;
	let q be Mercurial;
	let m be a random number between 1 and 100;
	repeat with n running from 1 to 20:
		choose row n in the Table of influences;
		if the Influence entry is Terrestrial:
			increase m by 1;
	if m is greater than Power of the Earth:
		change p to a random astral influence;
	otherwise:
		change p to Terrestrial;
	repeat with n running from 0 to 19:
		now m is 20 minus n;
		choose row m in the Table of influences;
		now q is Influence entry;
		now influence entry is p;
		now p is q;
	choose row 1 in the Table of influences;		
	now Current Influence is Influence entry.
				
[Last player's turn rule:
	repeat with n running from 1 to 20:
		choose row n in the Table of influences;
		say "n: [Influence entry]; ".]
		
Astral knowledge is a number that varies. Astral knowledge is 5.		

[To say predict the influences:
	unless Astral Knowledge is 0:
		repeat with n running from 1 to Astral knowledge:
			choose row n in the Table of influences;
			let m be the Influence entry;
			if m is Mercurial:
				say "[unicode Mercury][run paragraph on]";
			if m is Jovian:
				say "[unicode Jupiter][run paragraph on]";
			if m is Lunar:
				say "[unicode First Quarter Moon][run paragraph on]";
			if m is Martial:
				say "[unicode Male Sign][run paragraph on]";				
			if m is Venusian:
				say "[unicode Female Sign][run paragraph on]";
			if m is Terrestrial:
				say "-[run paragraph on]".]

To say predict the influences:
	unless Astral Knowledge is 0:
		repeat with n running from 1 to Astral knowledge:
			choose row n in the Table of influences;
			let m be the Influence entry;
			if m is Mercurial:
				say "M[run paragraph on]";
			if m is Jovian:
				say "J[run paragraph on]";
			if m is Lunar:
				say "L[run paragraph on]";
			if m is Martial:
				say "A[run paragraph on]";				
			if m is Venusian:
				say "V[run paragraph on]";
			if m is Terrestrial:
				say "-[run paragraph on]".
				
				
Table of Fancy Status
left    	 central    	 right
"[location]"    	 " "    	 " "
"Influence: [predict the influences] "    	 " "    	 " "


Rule for constructing the status line:
     fill status bar with Table of Fancy Status;
     rule succeeds.




Part - New abilities, characteristics, et cetera

Chapter - Statistics

Section - Will

[A measure of a person's defence against mental attacks.]

A person has a number called Will. The will of a person is usually 10.





Part - Powers




Chapter - Mercurial powers

Section - Planning

Planning is an action applying to one number. Understand "plan [a number]" as planning.

The plan bonus is a number that varies. The plan bonus is 0.
The plan counter is a number that varies. The plan counter is usually 0.

Check planning (this is the plan a positive number of turns rule):
	if the number understood is less than 1:
		take no time;
		say "You must plan into the future." instead.
	
Check planning (this is the plan a not too large number of turns rule):
	if the number understood is greater than 20:
		take no time;
		say "You cannot plan that far into the future." instead.
	
Check planning (this is the only plan during combat rule):
	if not hate is present:
		take no time;
		say "You cannot plan an attack when there are no enemies." instead.	
	
Check planning (this is the planning is an action rule):
	if the combat state of the player is at-React:
		take no time;
		say "Planning is an action, not a reaction." instead.
		
	
Take away until attack circumstances rule (this is the attacking interrupts planning rule):
	if the global attacker is the player:
		if the plan counter is not 0:
			now the plan counter is 0;
			say "[italic type](Your attack has interrupted your planning.)[roman type]";
		now the plan bonus is 0.
			
Carry out planning (this is the set planning variables rule):
	if the plan counter is not 0:
		say "You override your earlier plan.";
	now the plan counter is the number understood;
	now the plan bonus is the number understood;
	say "You plan an accurate attack in ", the number understood, " turns.".
	
A player's turn rule (this is the decrease planning counter rule):
	if the plan counter is greater than 0:
		decrease the plan counter by 1.

Starting the combat round rule (this is the planning notification rule):
	if the global attacker is the player:
		if the plan counter is 0 and the plan bonus is not 0:
			say "[bold type](Remember: you will get your planning bonus this turn.)[roman type][line break]".

An attack modifiers rule (this is the non-mercurial planning attack bonus rule):
	if the global attacker is the player and the current influence is not mercurial:
		if the plan counter is 0:
			if the plan bonus is not 0:
				let n be plan bonus divided by 2;
				if the numbers boolean is true:
					say " + ", n, " (planning bonus)[run paragraph on]";
				increase the to-hit modifier by n.

An attack modifiers rule (this is the mercurial planning attack bonus rule):
	if the global attacker is the player and the current influence is mercurial:
		if the plan counter is 0:
			if the plan bonus is not 0:
				let n be plan bonus times 2;
				let n be n divided by 2;
				if the numbers boolean is true:
					say " + ", n, " (mercurial planning bonus)[run paragraph on]";
				increase the to-hit modifier by n.

A damage modifiers rule (this is the mercurial planning damage bonus rule):
	if the global attacker is the player and the current influence is mercurial:
		if the plan counter is 0:
			if the plan bonus is not 0:
				let n be plan bonus divided by 4;
				if the numbers boolean is true and n is not 0:
					say " + ", n, " (mercurial planning bonus)[run paragraph on]";
				increase the damage modifier by n.
				





Chapter - Jovian Powers

Section - Awe

A person can be awed or not awed. A person is usually not awed.

Awing is an action applying to one thing. Understand "awe [person]" as awing.

A check awing rule (this is the only awe the living rule):
	if the noun is not alive:
		take no time;	
		say "[The noun] is already dead." instead.

A check awing rule (this is the awing yourself rule):
	if the noun is the player:
		take no time;
		say "You stand in awe of yourself." instead.
		
A check awing rule (this is the do not awe friendly or neutral people rule):
	if the faction of the player does not hate the faction of the noun:
		take no time;
		say "[The noun] is not your enemy." instead.

A carry out awing rule (this is the awe a person rule):
	now the noun is awed;
	say "You attempt inspire fear with your towering presence.".

First carry out an actor attacking when the fight consequences variable is true (this is the perhaps do not attack when awed rule):
	if the actor is awed and the noun is the player:
		let n be a random number between 2 and the will of the actor;
		increase n by the concentration of the actor;
		let m be a random number between 1 and 5;
		if the current influence is Jovian:
			increase m by a random number between 1 and 5;		
		if m is greater than n:
			say "[The actor] moves in to attack, but is frightened away at the last moment by your imposing presence[if the current influence is jovian], made even more awesome through the influence of Jupiter[end if]." instead.

Every turn (this is the awe goes away rule):
	unless the current action is awing:
		if the global attacker is awed:
			if a random chance of 1 in 2 succeeds:
				now the global attacker is not awed.



Section - Domination




Chapter - Venusian Powers

Section - Bond

Bonding is an action applying to one thing. Understand "bond [person]" and "bond with [person]" as bonding.

Being bonded relates people to each other.

The verb to be bonded implies the being bonded relation.

Check bonding (this is the only bond with enemies rule):
	if the faction of the actor hates the faction of the noun:
		take no time;
		say "Sett" instead.






Chapter - Lunar Powers

Section - Mist

Misting is an action applying to nothing. Understand "mist" as misting.

A person is either misted or not misted. A person is usually not misted.

The just misted boolean is a truth state that varies. The just misted boolean is false.

Carry out misting:
	say "You turn into thin mist.";
	now the player is misted;
	now the just misted boolean is true.

Every turn (this is the unmist out of combat rule):
	if not hate is present:
		if the player is misted:
			now the player is not misted;
			say "There are no enemies, so you immediately return to the state of flesh.".

An every turn rule (this is the unmist rule):
	if the global attacker is misted:
		unless the global attacker is the player and the just misted boolean is true:
			now the global attacker is not misted;
			if the global attacker is the player:
				if a random chance of 1 in 10 succeeds:
					say "You find yourself to be composed no longer of cool
imponderable vapor, but of the warmest and hardest sort of flesh
everywhere.";
				otherwise:
					say "You once again become solid flesh.";
	now the just misted boolean is false.
				
Calculate the final damage rule (this is the less damage when attacker is misted rule):
	if the global attacker is misted:
		if the current influence is not lunar:
			if the numbers boolean is true:
				say " (divided by two because attacker is in mist form)[run paragraph on]";
			now final damage is final damage divided by 2;
		otherwise:
			if the numbers boolean is true:
				say " (divided by ten because attacker is in mist form)[run paragraph on]";
			now final damage is final damage divided by 10.

Calculate the final damage rule (this is the less damage when defender is misted rule):
	if the global defender is misted:
		if the current influence is not lunar:
			if the numbers boolean is true:
				say " (divided by two because defender is in mist form)[run paragraph on]";
			now final damage is final damage divided by 2;
		otherwise:
			if the numbers boolean is true:
				say " (divided by ten because defender is in mist form)[run paragraph on]";
			now final damage is final damage divided by 10.


Standard AI action select rule (this is the less likely to attack when attacker is misted rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the global attacker is misted:
		decrease the Weight entry by 3;
		if the current influence is Lunar:
			decrease the weight entry by 30.

Standard AI action select rule (this is the less likely to attack when defender is misted rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the global defender is misted:
		decrease the Weight entry by 3;
		if the current influence is Lunar:
			decrease the weight entry by 30.




Chapter - Martial Powers

Section - Mars Interfector
[Slayer]

A person is either follower-of-Mars-Interfector or not follower-of-Mars-Interfector. A person is usually not follower-of-Mars-Interfector

Damage modifiers rule (this is the Mars Interfector damage rule):
	if the global attacker is follower-of-Mars-Interfector:
		if the current influence is martial:
			if the numbers boolean is true:
				say " + 2 (Mars Interfector)[run paragraph on]";
			increase the damage modifier by 2.	

[TEST]
The player is follower-of-Mars-Interfector.

Standard AI action select rule (this is the more likely to attack when Interfector bonus rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the global attacker is follower-of-Mars-Interfector:
		if the current influence is martial:
			increase the Weight entry by 2.



Section - Mars Condatis
[Healing]




Section - Mars Ultor 
[Avenger]




Book - Additions to attack

[This:]

Every turn:
	if the global attacker is the player:
		consider the player's turn rulebook.
		
The player's turn rules are a rulebook.
	
[Fixed: going to a new location runs attacks correctly.]
[Added: starting the combat round rules.]













